/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.client.render.alchemyarray;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import wayoftime.bloodmagic.client.render.BloodMagicRenderer;
import wayoftime.bloodmagic.client.render.RenderResizableQuadrilateral;
import wayoftime.bloodmagic.client.render.alchemyarray.AlchemyArrayRenderer;
import wayoftime.bloodmagic.common.tile.TileAlchemyArray;

public class StaticAlchemyCircleRenderer
extends AlchemyArrayRenderer {
    public StaticAlchemyCircleRenderer(ResourceLocation arrayResource) {
        super(arrayResource);
    }

    @Override
    public float getRotation(float craftTime) {
        float offset = 50.0f;
        if (craftTime >= offset) {
            float modifier = (craftTime - offset) * 5.0f;
            return modifier * 1.0f;
        }
        return 0.0f;
    }

    @Override
    public float getSecondaryRotation(float craftTime) {
        return 0.0f;
    }

    @Override
    public float getSizeModifier(float craftTime) {
        return 1.0f;
    }

    @Override
    public void renderAt(TileAlchemyArray tileArray, double x, double y, double z, float craftTime, PoseStack matrixStack, MultiBufferSource renderer, int combinedLightIn, int combinedOverlayIn) {
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        float rot = this.getRotation(craftTime);
        float secondaryRot = this.getSecondaryRotation(craftTime);
        float size = 1.0f * this.getSizeModifier(craftTime);
        Direction rotation = tileArray.getRotation();
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, (double)this.getVerticalOffset(craftTime), 0.0);
        matrixStack.m_85845_(new Quaternion(Direction.UP.m_122432_(), -rotation.m_122435_(), true));
        matrixStack.m_85836_();
        matrixStack.m_85845_(new Quaternion(Direction.NORTH.m_122432_(), rot, true));
        VertexConsumer twoDBuffer = renderer.m_6299_(RenderType.m_110473_((ResourceLocation)this.arrayResource));
        BloodMagicRenderer.Model2D arrayModel = new BloodMagicRenderer.Model2D();
        arrayModel.minX = -0.5;
        arrayModel.maxX = 0.5;
        arrayModel.minY = -0.5;
        arrayModel.maxY = 0.5;
        arrayModel.resource = this.arrayResource;
        matrixStack.m_85841_(size, size, size);
        RenderResizableQuadrilateral.INSTANCE.renderSquare(arrayModel, matrixStack, twoDBuffer, -1, 0xF000F0, OverlayTexture.f_118083_);
        matrixStack.m_85849_();
        matrixStack.m_85849_();
        matrixStack.m_85849_();
    }
}

